# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-macros-mageia-compat
BuildRequires: perl(namespace/autoclean.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Object-ID
%define upstream_version v0.1.2

Name:       perl-%{upstream_name}
Version:    0.1.2
Release:    alt1_11

Summary:    Supply a unique object identifier to every object
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Object/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Hash/FieldHash.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Sub/Name.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(version.pm)
BuildArch:  noarch

# Don't provide perl(UNIVERSAL)
%{?perl_default_filter}
Source44: import.info


%description
This is a unique identifier for any object, regardless of its type,
structure or contents. Its features are:

    * Works on ANY object of any type
    * Does not modify the object in any way
    * Does not change with the object's contents
    * Is O(1) to calculate (ie. doesn't matter how big the object is)
    * The id is unique for the life of the process
    * The id is always a true value

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%check
./Build test

%install
./Build install destdir=%{buildroot}

%files
%doc Changes LICENSE META.json META.yml README SIGNATURE
%perl_vendor_privlib/*


%changelog
