%define module_name Object-Import
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(MRO/Compat.pm) perl(Math/BigInt.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.006
Release: alt1
Summary: import methods of an object as functions to a package
Group: Development/Perl
License: ARTISTIC, GPL
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CO/CORION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module lets you call methods of a certain object more easily by
exporting them as functions to a package.  The exported functions are
not called as methods and do not receive an object argument, but instead
the object is fixed at the time you import them with this module.

You use the module with the following syntax:

_use Object::Import $object, %%options;

Here, `$object' is the object from which you want to import the methods.
This can be a perl object (blessed reference), or the name of a package
that has class methods.

As usual, a `use' statement is executed in compile time, so you should
take care not to use values that you compute only in run-time, eg.

_my $object = Foo::Bar->new();
_use Object::Import $object; # WRONG: $object is not yet initialized

Instead, you have to create the object before you import, such as

_use Object::Import Foo::Bar->new();

You can also call import in run-time, eg.

_use Object::Import ();
_my $object = Foo::Bar->new();
_import Object::Import $object;

but in that case, you can't call the imported functions without parenthesis.

If you don't give an explicit list of methods to export, Object::Import
tries to find out what callable methods the object has and import
all of them.  Some methods are excluded from exporting in this case,
namely any methods where exporting would overwrite a function existing
in the target package or would override a builtin function, also
any methods with names that are special to perl, such as `DESTROY',
and any methods whose name starts with an underscore.  This automatic
search for methods is quite fragile because of the way perl OO works,
so it can find subroutines that shouldn't actually be called as methods,
or not find methods that can actually be called.  In particular, even
if you import an object from a purely object oriented module, it can
find non-method subs imported from other (non-OO) modules.

If you do give a list of methods to export, Object::Import trusts you
know what you mean, so it exports all those subs even if ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README TODO CHANGES ARTISTIC GPL
%perl_vendor_privlib/O*

%changelog
