# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Object-Lexical
%define upstream_version 0.02

Name:		perl-%{upstream_name}
Version:	%{upstream_version}
Release:	alt2_10

Summary:	Object::Lexical - Syntactic Sugar for Easy Object Instance Data &
License:	GPL+ or Artistic
Group:		Development/Perl
URL:		https://metacpan.org/release/%{upstream_name}
Source0:	%{upstream_name}-%{upstream_version}.tar.bz2

BuildRequires:	perl(PadWalker.pm)
BuildArch:	noarch
Source44: import.info


%description
Object::Lexical provides syntactic sugar to create objects.
Normal "my" variables are used for instance data. $this is
automatically read off of the argument stack. This follows "real"
OO languages, where user code need not concern itself with
helping the language implement objects.  Normal OO Perl code is
ugly, hard to read, tedious to type, and error prone.  The
"$self-"{field}> syntax is cumbersome, and using an object field
with a built in, like "push()", requires syntax beyond novice
Perl programmers: "push @{$self-"{field}}, $value>.  Spelling
field names wrong results in hard to find bugs: the hash
autovivicates, and no "variables must be declared" warning is
issued.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build
make test

%install
%makeinstall_std

%files
%doc Changes README
%{perl_vendor_privlib}/Object/Lexical.pm

%changelog
