# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin/libs.pm) perl(List/Util.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Sub/Name.pm) perl(Symbol.pm) perl(Test/More.pm) perl(mro/EVERY.pm)
# END SourceDeps(oneline)
%define module_name Object-Lvalue
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.0
Release: alt1
Summary: Fast, lightweight base class for objects using lvalue attributes.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LE/LEMBARK/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is a lightweight, fast base class for object with attribues
which are lvalues. This means that syntax like:

    $object->attribute_name     = 42;

works to assin attribute values. The core object is an array which is 
fast to access, compact, and stored in a single place for simpler
export and cleanup.

This base class provides minimal services to construct, initialize,
copy (deep clone or shallow), and DESTROY the objects along with 
simple introspection providing the attribute names specific to the
class and all of the attributes including inherited ones. 

The basic structure stacks each set of attributs further down the
object, making it simple to override inherited attributes: they 
are stored in separate slots and won't overwrite one another. This
is similar to inside-out class structure but has the advantge [for
some definintion of Christmas] of keeping the entire object in one
place for simpler copying, export, and cleanup.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CHANGES
%perl_vendor_privlib/O*

%changelog
