%define module_name Object-Method
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: attach method to objects instead of classes.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GU/GUGOD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Object::Method lets you attach methods to methods to object but not
its classes. There are two different ways to use this module. Keep reading.

The first way is to use it to create a class that allows user to
attach methods at runtime. To do this, simply put 'use Object::Method' in your
class body like this:

    package Stuff;
    use Object::Method;

This effectively exports a `method' method to your class, which can be used to
create new methods like this:

    my $o = Stuff->new;

    $o->method("foo" => sub { ... });

The `method' method takes exactly two arguments: the method name, and
a sub-routine or code-ref. After calling that `method' method on
object `$o', a new method `foo' will be attached to `$o' and can be
invoked only on `$o'.

The second way is to use it on all objects through
`UNIVERSAL::Object::Method' like this:

    use UNIVERSAL::Object::Method;
    use SomeClass;

    my $o = SomeClass->new;

    $o->method("foo" => sub { ... });

This is an overwhelming way due to the use of the UNIVERSAL manpage namespace. If
you are not familiar with it, read the linked documentation.

Please notice that calling the `method' method multiple times
obviously override previous definition and there is no way to undo
this for now.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/O*
%perl_vendor_privlib/U*

%changelog
