%define module_name Object-Pad-Keyword-Accessor
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/CBuilder.pm) perl(File/ShareDir.pm) perl(Module/Build.pm) perl(Object/Pad.pm) perl(Object/Pad/ExtensionBuilder.pm) perl(Test2/V0.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Keyword/Builder.pm) perl(XS/Parse/Sublike.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: declare lvalue accessors on C<Object::Pad> classes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PEVANS/%{module_name}-%{version}.tar.gz

%description
This module provides a new keyword for declaring accessor methods that behave
as lvalues as members of the Object::Pad manpage-based classes.

While `Object::Pad' does permit fields of classes to be exposed to callers
via lvalue mutator methods by using the `:mutator' field attribute, these are
generally not that useful in real cases. Fields exposed using this technique
have no validation, and cannot trigger any other code to be executed after
update.

The the accessor entry elsewhere in this document keyword provided by this module offers an alternative. The
lvalue accessor methods it provides into the class fully support running
arbitrary code on read and write access, permitting any kind of check or
triggering action. In fact, the accessor does not even need to be directly
backed by a field at all. The accessor permits the class to specify its
interface by which other code will interact with it, without being forced into
any particular implementation of that interface.

This module is a very early proof-of-concept, both of the syntax itself and
the underlying ability of `Object::Pad' to support such syntax extensions as
a third-party module.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_archlib/O*
%perl_vendor_autolib/*

%changelog
