%define module_name Object-PadX-Log-Log4perl
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IO/Scalar.pm) perl(IPC/Open3.pm) perl(Log/Log4perl.pm) perl(Object/Pad.pm) perl(Test/More.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Sublike.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: A logger role for Object::Pad based classes based on Log::Log4perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WA/WATERKIP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A logging role building a very lightweight wrapper to the Log::Log4perl manpage for use
with your the Object::Pad manpage classes. The initialization of the Log4perl instance
must be performed prior to logging the first log message.  Otherwise the
default initialization will happen, probably not doing the things you expect.

The logger needs to be setup before using the logger, which could happen in the
main application:

    package main;
    use Log::Log4perl qw(:easy);
    use MyClass;

    BEGIN { Log::Log4perl->easy_init() }

    my $myclass = MyClass->new();
    $myclass->log->info("In my class");    # Access the log of the object
    $myclass->dummy;                       # Will log "Dummy log entry"

Using the logger within a class is as simple as consuming a role:

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE CONTRIBUTORS
%perl_vendor_privlib/O*

%changelog
