# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Hash/Util/FieldHash.pm) perl(Keyword/Simple.pm) perl(List/Util.pm) perl(Method/Signatures.pm) perl(PPI.pm) perl(Test/More.pm) perl(autodie.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_name Object-Result
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.000003
Release: alt1
Summary: Allow subs to build and return objects on-the-fly
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DC/DCONWAY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module adds a new keyword to Perl: `result'

That keyword acts like a `return', but instead of a list of values to
return, it takes a single block which specifies the behaviour
(i.e. the methods and operator overloading) of an object to be returned.

The intention is to make it much less onerous to return clean,
properly encapsulated objects...instead of returning lists of values
or references to arrays or hashes.

For example, instead of:

    my ($ID, $name, $uptime, $load, $users, $location, $contact)
        = get_server_status($server_ID);

    if ($uptime) {
        say "$ID ($name) load: $load";
    }

or:

    my $server = get_server_status($server_ID);

    if ($server->{uptime}) {
        say "$server->{ID} ($server->{name) load: $server->{load}";
    }

you can arrange the API to be object-based:

    my $server = get_server_status($server_ID);

    if ($server->is_up) {
        say $server->describe, ' load: ', $server->load;
    }

The real advantage is that, inside the module providing
`get_server_status()' you don't have to define a separate class
implementing the objects returned by that subroutine. More importantly,
if you have a dozen subroutines returning specialized objects, you don't
have to define a dozen separate classes to support them.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/O*

%changelog
