%define module_name Object-Tap
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Exporter.pm) perl(Module/Build.pm) perl(Module/Build/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000006
Release: alt1
Summary: Tap into a series of method calls to alter an object
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MS/MSTROUT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Instead of writing -

  my $thing = My::Class->new(...);
  
  $thing->set_foo(1);

you can instead write -

  use Object::Tap;
  
  my $thing = My::Class->new(...)->$_tap(sub { $_[0]->set_foo(1) });

To realise why this might be useful, consider instead -

  My::App->new(...)->$_tap(...)->run;

where a variable is thereby not required at all.

You can also pass extra args -

  $obj->$_tap(sub { warn "Got arg: $_[1]" }, 'arg');

or use a method name instead of a sub name -

  my $thing = My::Class->new(...)->$_tap(set_foo => 1);


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE
%perl_vendor_privlib/O*

%changelog
