%define module_name OpenStack-Client
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(URI/Encode.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0007
Release: alt1
Summary: A nice and tiny OpenStack API client
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/X/XA/XAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`OpenStack::Client' is a no-frills OpenStack API client which provides generic
access to OpenStack APIs with minimal remote service discovery facilities; with
a minimal client, the key understanding of the remote services are primarily
predicated on an understanding of the authoritative OpenStack API documentation:

    http://developer.openstack.org/api-ref.html

Authorization, authentication, and access to OpenStack services such as the
OpenStack Compute and Networking APIs is made convenient by
the OpenStack::Client::Auth manpage.  Further, some small handling of response body data
such as obtaining the full resultset of a paginated response is handled for
convenience.

Ordinarily, a client can be obtained conveniently by using the `services()'
method on a the OpenStack::Client::Auth manpage object.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE examples
%perl_vendor_privlib/O*

%changelog
