%define module_name OpenTracing-AutoScope
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/Hooks/OP/Check/LeaveEval.pm) perl(Caller/Hide.pm) perl(Capture/Tiny.pm) perl(Data/Perl/Role/Collection/Hash.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(List/MoreUtils.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(OpenTracing/GlobalTracer.pm) perl(OpenTracing/Implementation.pm) perl(OpenTracing/Implementation/NoOp.pm) perl(PPI.pm) perl(Perl/Critic/Utils/McCabe.pm) perl(PerlX/Maybe.pm) perl(Pod/Usage.pm) perl(Scope/Context.pm) perl(Sub/Info.pm) perl(Test/Deep.pm) perl(Test/Most.pm) perl(Test/OpenTracing/Integration.pm) perl(YAML/XS.pm) perl(autodie.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.107.4
Release: alt1
Summary: Automagically create and close scoped spans.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VA/VANHOESEL/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Using the `start_guarded_span' class method is just a convenience around things
like:

    use OpenTracing::GlobalTracer qw/$TRACER/;
    
    sub foo {
        my $scope = $TRACER->start_active_span( 'MyPackage::foo' => { options };
        
        my $self = shift;
        
        ... # do stuff
        
        $scope->close
        
        return $foo
    }



OpenTracing provides a instance method for a `$tracer', called
`start_active_span' and returns a scope object. But scope object, according to
the API spec need to be closed by the programmer and it will issue a warning if
not done so.

But that strategy becomes very inconvenient if a programmer wants to do 'return
early' or bail out half way because of some other conditions.

This being Perl, we can do better and use the feaures that would normally come
on the end of scope and could use a `DESTROY' or `DEMOLISH' method. But that
would still send out a warning.

This module will make it easy again, and a bit more. It will call `close' on
the relevant scope it has created automagically.

It will also use the subroutine name as the operation name, that otherwise would
be required.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE.md CHANGES README.md
%perl_vendor_privlib/O*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
