# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/Sodium.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(MIME/Base64.pm) perl(Moo.pm) perl(Test/More.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define module_version 0.008
%define module_name OpusVL-SimpleCrypto
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.008
Release: alt1
Summary: Very simple encryption methods.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NEWELLC/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Simple encrypt and decrypt methods.

    my $s = OpusVL::SimpleCrypto->GenerateKey;
    print $s->key_string, "\n";
    print $s->deterministic_salt_string, "\n";
    my $ct = $s->encrypt('Test');
    my $ct2 = $s->encrypt_deterministic('Test');


    my $crypto = OpusVL::SimpleCrypto->new({
        key_string => $key_string
        deterministic_salt_string => $deterministic_salt_string
    });
    my $message = $crypto->decrypt($ct);
    my $message2 = $crypto->decrypt($ct2);

This uses Crypt::Sodium under the hood to do simple symmetric (authenticated)
encryption and decryption.

This is for storing information encrypted in a database.  Make sure the key
is not in the database at the same time, otherwise this all becomes a bit
academic.

On debian derivative systems you probably need to install the libsodium-dev
package.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/O*

%changelog
