%define module_name P
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(PerlIO.pm) perl(Test/Simple.pm) perl(Types/Core.pm) perl(Xporter.pm) perl(mem.pm) perl(version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.41
Release: alt1
Summary: safer+easier [s]print[f], & say all-in-1
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LA/LAWALSH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`P' is a combined printf, sprintf & say in 1 routine.  It was designed
to save on typing and undef checking when printing strings.  It saves on
in that you don't have constantly insert or move `newline's (`\n').  
If you change a string into a formatted string, insert P, as in:

  die "Wrong number of params";
             # to
  die P "Expecting 2 params, got %%s", scalar @ARGV;


When printed as
strings (`"%%s"'), undefs are automatically caught and "E<0x2204>", (U+2204 - 
meaning "*There does not exist*") is
printed in place of "`Use of uninitialized value $x in xxx at -e line z.'"

By default `P', prints the content of references (instead HASH 
(or ARRAY)=(0x12345678), three levels deep.  Deeper nesting is replaced
by the unicode ellipsis character (U+2026).

While designed for development use, it is useful in many more situations, as 
tries to "do the right thing" based on context.  It can usually be used
as a drop-in replacement the perl functions `print', `printf', `sprintf',
and, `say'.  

P tries to smartly handle newlines at the end of the line -- adding them 
or subtracting them based on if they are going to a file handle or to another
variable.

The newline handling at the end of a line can be supressed by adding
the Unicode control char "Don't break here" (0x83) at the end of a string
or by assigning the return value and having a file handle as the first
argument.  Ex: `my $fmt = P STDOUT, "no LF added here-->"'.


`Bless'ed objects, by default,  are printed with the Class or package name
in front of the reference.   Note that these substitutions are performed only with 
references printed through a string (`"%%s"') format -- features designed
to give useful output in development or debug situations.

One minor difference between `P' and `sprintf': `P' can take 
an array with the format in the 0th element, and parameters following.  
`Sprintf' will cause an error to be raised, if you try passing an array
to it, as it will force the array into scalar context -- which as 
the manpage says "is almost never useful".  Rather than follow in the
design flaws of its predecessors, P *tries* to do the right thing.


NOTE: A side effect of P being a contextual replacement for sprintf,
is if it is used as the last line of a subroutine.  By default, this
won't print it's arguments to STDOUT unless you explicity specify the
filehandle, as it will think it is supposed to return the result -- not
print it.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/P*

%changelog
