%define module_name P2-Scheduler
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Printer.pm) perl(Date/Calc.pm) perl(ExtUtils/MakeMaker.pm) perl(Getopt/Long.pm) perl(Moose.pm) perl(POSIX.pm) perl(Test/More.pm) perl(UUID.pm) perl(YAML/Syck.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: This module helps organizing monthly tests at component level.
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRUBERT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use P2::Scheduler;

    my $scheduler = P2::Scheduler->new(
        experiments     => [][],        # experiments ordered by priority (mandatory)
        weight          => [3,2,1],     # the weight of each priority, basically how many tests to run for a 
                                        # given priority (defaults to [3,2,1])
        hour_slots      => [1,2,3,4,5], # hours of the day at which tests can run (mandatory)
        spare_days_per_month => 2,      # number of business days to leave as spare at the end of the month
        starting_from   => 6,           # index of the day of the month to start from (defaults to 1)
        year            => ...          # mandatory
        num_week_days   => 3            # number of business days to count starting from Monday, defaults to 5
        pri_per_month' => [3,3,3,3,3,3,3,3,3,3,3,3] # an array for the minimum priority to take into consideration when scheduling 
                                        # experiments for each month. Default to all
                                        # priorities for all months. This is meant to be
                                        # used in case we want to limit priority 2/3
                                        # experiments only to specific months.
        selected_week_days => [3,4],    # list of business days ids to consider:
                                        # 1 => Monday,..., 5 => Friday
                                        # for example the string '2,3,4' would set tests to run only
                                        # between Tuesdays and Thursdays
        fixed_intervals => 1            # if experiments times should be strictly scheduled in 
                                        # fixed intervals or randomly allocated

    );

    # getting the schedule for January...
    my @schedule = $scheduler->month_schedule(1);

    # or for the whole year...
    my @schedule = $scheduler->year_schedule();

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes ignore.txt README LICENSE
%perl_vendor_privlib/P*

%files scripts
%_bindir/*

%changelog
