# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    PAUSE-Permissions
%define upstream_version 0.17

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    PAUSE permissions for one module (from 06perms.txt)
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/PAUSE/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/HomeDir.pm)
BuildRequires: perl(File/Spec/Functions.pm)
BuildRequires: perl(HTTP/Date.pm)
BuildRequires: perl(HTTP/Tiny.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Moo.pm)
BuildRequires: perl(MooX/Options.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Time/Duration/Parse.pm)
BuildRequires: perl(autodie.pm)
BuildRequires: perl(feature.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
PAUSE::Permissions provides an interface to the '06perms.txt' file produced
by the Perl Authors Upload Server (PAUSE). The file records who has what
permissions for every module on CPAN. The format and interpretation of this
file are covered in the /"The 06perms.txt file" manpage below.

By default, the module will mirror '06perms.txt' from CPAN, using the
HTTP::Tiny manpage to request it and store it locally. By default it will
get the file from the http://www.cpan.org manpage, but you can pass an
alternate URI to the constructor:

  $perms_uri = "http://$CPAN_MIRROR/modules/06perms.txt";
  $pp = PAUSE::Permissions->new(uri => $perms_uri);

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%{_bindir}/pause-permissions
%{_mandir}/man1/*
%{perl_vendor_privlib}/*


%changelog
