%define module_name PDF-TableX
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/Types.pm) perl(MooseX/Types/Moose.pm) perl(Net/FTP.pm) perl(PDF/API2.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.015
Release: alt1
Summary: Moose driven table generation module that is uses famous PDF::API2
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PA/PAPKALA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The module provides capabilities to create tabular structures in PDF files.
It is similar to PDF::Table module, however extends its functionality adding OO
interface and allowing placement of any element inside table cell such as image,
another pdf, or nested table.

Sample usage:

_use PDF::API2;
_use PDF::TableX;

_my $pdf = PDF::API2->new();
_my $page = $pdf->page;
_my $table = PDF::TableX->new(40,40);        # create 40 x 40 table
_$table
__->padding(3)                        # set padding for cells
__->border_width(2)                   # set border width
__->border_color('blue');             # set border color
_$table->[0][0]->content("Sample text");     # place "Sample text" in cell 0,0 (first cell in first row)
_$table->[0][1]->content("Some other text"); # place "Some other text" in cell 0,1
_$table->draw($pdf, $page);                  # place table on the first page of pdf

_$pdf->saveas('some/file.pdf');


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
