%define module_name PDL-Graphics-Simple
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(PDL.pm) perl(PDL/Graphics/Gnuplot.pm) perl(Prima/Application.pm) perl(Prima/Buttons.pm) perl(Prima/Edit.pm) perl(Prima/Label.pm) perl(Prima/PodView.pm) perl(Prima/Utils.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.010
Release: alt1
Summary: Simple backend-independent plotting for PDL
Group: Development/Perl
License: perl
URL: https://github.com/PDLPorters/PDL-Graphics-Simple

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
PDL can plot through a plethora of external plotting modules.  Each
module tends to be less widely available than Perl itself, and to
require an additional step or two to install.  For simple applications
("throw up an image on the screen", or "plot a curve") it is useful to
have a subset of all plotting capability available in a backend-independent
layer.  PDL::Graphics::Simple provides that capability.

PDL::Graphics::Simple implements all the functionality used in the
PDL::Book examples, with identical syntax.  It also generalizes that
syntax - you can use ::Simple graphics, with slight syntactical
differences, in the same manner that you would use any of the engine
modules.  See the Examples below for details.

The plot you get will always be what you asked for, regardless of
which plotting engine you have installed on your system.

Only a small subset of PDL's complete graphics functionality is
supported -- each individual plotting module has unique advantages and
functionality that are beyond what PDL::Graphics::Simple can do.  Only
2-D plotting is supported.  For 3-D plotting, use
PDL::Graphics::Gnuplot or PDL::Graphics::Trid directly.

When plotting to a file, the file output is not guaranteed to be
present until the plot object is destroyed (e.g. by being undefed or
going out of scope).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.pod
%perl_vendor_privlib/P*

%changelog
