# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/ODBC.pm) perl(DBD/Pg.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(PDL.pm) perl(Test/More.pm) perl(Test/Number/Delta.pm) perl(Time/Moment.pm)
# END SourceDeps(oneline)
%define module_name PDL-IO-DBI
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.012
Release: alt1
Summary: Create PDL from database (optimized for speed and large data)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KM/KMX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
For creating a piddle from database data one can use the following simple approach:

  use PDL;
  use DBI;
  my $dbh = DBI->connect($dsn);
  my $pdl = pdl($dbh->selectall_arrayref($sql_query));

However this approach does not scale well for large data (e.g. SQL queries resulting in millions of rows).

This module is optimized for creating piddles populated with very large database data. It currently supports only
reading data from database not updating/inserting to DB.

The goal of this module is to be as fast as possible. It is designed to silently converts anything into a number
(wrong or undefined values are converted into `0').

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/P*

%changelog
