%define module_name PDL-IO-Dcm
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Zip.pm) perl(DicomPack/DB/DicomTagDict.pm) perl(DicomPack/DB/DicomVRDict.pm) perl(DicomPack/IO/DicomReader.pm) perl(ExtUtils/MakeMaker.pm) perl(Getopt/Tabular.pm) perl(List/Util.pm) perl(PDL.pm) perl(PDL/IO/Sereal.pm) perl(Storable.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.011
Release: alt1
Summary: Reads dicom files, sorts them and stores the result into piddles with headers
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FA/FANTASMA/%{module_name}/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is inteded to read and sort dicom images created by medical imaging devices. 
Either use something like the following from within your module/application

_use PDL::IO::Dcm::Plugins::Primitive qw/setup_dcm/;
_my %%options=();
_...
_setup_dcm(\%%options);
_# loads all dicom files in this directory
_my $dcms=load_dcm_dir($dir,\%%options); 
_die "no data!" unless (keys %%$dcms);
_print "Read data; IDs: ",join ', ',keys %%$dcms,"\n";
_# sort all individual dicoms into a hash of piddles.
_my $data=parse_dcms($dcms,\%%options);

_... # do something with your data.

or use the read_dcm.pl script to convert dicom files in a directory to serealised
piddles (PDL::IO::Sereal) or NIFTI files with separate text headers (PDL::IO::Nifti).

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
