%define module_name PDL-Opt-Simplex-Simple
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Math/Round.pm) perl(PDL.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.8
Release: alt1
Summary: A simplex optimizer for the rest of us (who may not know PDL).
Group: Development/Perl
License: gpl
URL: https://github.com/KJ7LNW/perl-PDL-Opt-Simplex-Simple

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EW/EWHEELER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class uses the PDL::Opt::Simplex manpage to find the values for `vars'
that cause the `f' coderef to return the minimum value.  The difference
between the PDL::Opt::Simplex manpage and the PDL::Opt::Simplex::Simple manpage is that
the PDL::Opt::Simplex manpage expects all data to be in PDL format and it is
more complicated to manage, whereas, the PDL::Opt::Simplex:Simple manpage uses
all scalar Perl values. (PDL values are not supported, or at least,
have not been tested.)

With the original the PDL::Opt::Simplex manpage module, a single vector array
had to be sliced into the different variables represented by the array.
This was non-intuitive and error-prone.  This class attempts to improve
on that by defining data structure of variables, values, and whether or
not a value is enabled for optimization.

This means you can selectively disable a particular value and it will be
excluded from optimization but still included when passed to the user's
callback function `f'.  Internal functions in this class compile the state
of this variable structure into the vector array needed by simplex,
and then extract values into a usable format to be passed to the user's
callback function.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ignore.txt README.md Changes README
%perl_vendor_privlib/P*

%changelog
