%define module_name PDL-Transform-Color
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(PDL.pm) perl(PDL/Graphics/ColorSpace.pm) perl(PDL/MatrixOps.pm) perl(PDL/Transform.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.007
Release: alt1
Summary: Useful color system conversions for PDL
Group: Development/Perl
License: perl
URL: http://github.com/PDLPorters/PDL-Transform-Color

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
PDL::Transform::Color includes a variety of useful color conversion
transformations.  It can be used for simple hacks on machine-native
color representations (RGB <-> HSV, etc.), for simple
encoding/decoding of machine-native color representations such as
sRGB, or for more sophisticated manipulation of absolute color
standards including large-gamut or perceptual systems.

The color transforms in this module can be used for converting between
proper color systems, for gamma-converting pixel values, or for
generating pseudocolor from one or two input parameters.  In addition
to transforming color data between different representations, Several
named "color maps" (also called "color tables") are provided.

The module uses linearized sRGB (lsRGB) as a fundamental color basis.
sRGB is the standard color system used by most consumer- to mid-grade
computer equipment, so casual users can use this color representation
without much regard for gamuts, colorimetric standards, etc.

Most of the transform generators convert from lsRGB to various
other systems.  Notable simple ones are HSV (Hue, Saturation, Value),
HSL (Hue, Saturation, Lightness), and CMYK (Cyan, Magenta, Yellow,
blacK).

If you aren't familiar with PDL::Transform, you should read that POD
now, as this is a subclass of PDL::Transform.  Transforms represent
and encapsulate vector transformations -- one- or two-way vector
functions that may be applied, composed, or (if possible) inverted.
They are created through constructor methods that often allow
parametric adjustment at creation time. 

If you just want to "manipulate some RGB images" and not learn about
the esoterica of color representations, you can treat all the routines
as working "from RGB" on the interval [0,1], and use `t_srgb' to
import/export color images from/to "24-bit color" that your computer
probably expects.  If you care about the esoterica, read on.

The output transfer function for sRGB is nonlinear -- the luminance of
a pixel on-screen varies somewhat faster than the square of the i...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO README.pod CHANGES LICENSE
%perl_vendor_privlib/P*

%changelog
