%define module_name PGXN-Site
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dump.pm) perl(Email/MIME.pm) perl(Email/Sender/Simple.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(Gravatar/URL.pm) perl(HTML/TagCloud.pm) perl(HTTP/Message/PSGI.pm) perl(HTTP/Request/Common.pm) perl(I18N/LangTags/Detect.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Locale/Maketext.pm) perl(Module/Build.pm) perl(Plack.pm) perl(Plack/App/File.pm) perl(Plack/Builder.pm) perl(Plack/Request.pm) perl(Plack/Response.pm) perl(Plack/Test.pm) perl(Pod/Usage.pm) perl(Router/Resource.pm) perl(SemVer.pm) perl(Software/License.pm) perl(Template/Declare.pm) perl(Template/Declare/Tags.pm) perl(Test/File/Contents.pm) perl(Test/MockModule.pm) perl(Test/More.pm) perl(WWW/PGXN.pm) perl(namespace/autoclean.pm)
BuildRequires: perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.23.8
Release: alt1
Summary: Maintain and serve a PGXN web site
Group: Development/Perl
License: perl
URL: https://www.pgxn.org/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DW/DWHEELER/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
PGXN is a CPAN-inspired network for
distributing extensions for the PostgreSQL RDBMS.
All of the infrastructure tools, however, have been designed to be used to
create networks for distributing any kind of release distributions and for
providing a lightweight static file JSON REST API.

This module provides a simple PGXN web site. All it needs is a
the PGXN::API manpage-powered API to get the data it needs. Such an API can be accessed
either remotely or via the local file system.

To run your own PGXN web server, just install this module and run the included
the section on "<pgxn_site_server" the Plack manpage server, passing it the following options:

=over

=item `api_url'

The URL to use to access the the PGXN::API manpage server. Required.

=item `private_api_url'

A private URL to use to access the the PGXN::API manpage-powered API. Optional. Useful
if you're serving the site and the API from the same box (or with access to
the same file system) and want it to be fast: just specify a `file:' URL here
and the API will be read directly from the file system. The `api_url' option
will still be used for public URLs pointing to the API in the UI.

=item `proxy_url'

If you need to access `private_api_url' via a proxy server, provide the URL for that
proxy server in this option.

=item `errors_to'

An email address to which error emails should be sent. In the event of an
internal server error, the server will send an email to this address with
diagnostic information.

=item `errors_from'

An email address from which alert emails should be sent.

=item `feedback_to'

An email address to which feedback emails should be sent. This email address
will be provided as a clickable link.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/P*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
