# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    POE-Component-Client-MPD
%define upstream_version 2.001

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

Summary:    POE component to speak with MPD servers
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/POE/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Audio/MPD/Common/Item.pm)
BuildRequires: perl(Audio/MPD/Common/Stats.pm)
BuildRequires: perl(Audio/MPD/Common/Status.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(List/AllUtils.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Util/TypeConstraints.pm)
BuildRequires: perl(MooseX/Has/Sugar.pm)
BuildRequires: perl(MooseX/POE.pm)
BuildRequires: perl(MooseX/SemiAffordanceAccessor.pm)
BuildRequires: perl(MooseX/Types/Moose.pm)
BuildRequires: perl(POE.pm)
BuildRequires: perl(POE/Component/Client/TCP.pm)
BuildRequires: perl(Readonly.pm)
BuildRequires: perl(Sub/Exporter.pm)
BuildRequires: perl(Test/Corpus/Audio/MPD.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
POCOCM gives a clear message-passing interface (sitting on top of POE) for
talking to and controlling MPD (Music Player Daemon) servers. A connection
to the MPD server is established as soon as a new POCOCM object is created.

Commands are then sent to the server as messages are passed.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%check
./Build test

%install
./Build install destdir=%{buildroot}

%files
%doc Changes LICENSE META.json META.yml  README TODO examples
%{perl_vendor_privlib}/*


%changelog
