Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Email/MIME/Creator.pm) perl(IO/All.pm) perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform optional tests
%bcond_without perl_POE_Component_Client_SMTP_enables_optional_test

Name:           perl-POE-Component-Client-SMTP
Version:        0.22
Release:        alt3_45
Summary:        Asynchronous mail sending with POE
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl        
URL:            https://metacpan.org/release/POE-Component-Client-SMTP
Source0:        https://cpan.metacpan.org/authors/id/U/UL/ULTRADM/POE-Component-Client-SMTP-%{version}.tar.gz
# Do not use /usr/bin/env in shebangs
Patch0:         POE-Component-Client-SMTP-0.22-Normalize-shebangs.patch
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Data/Dumper.pm)
# MIME::Base64 not used at tests
BuildRequires:  perl(POE.pm)
BuildRequires:  perl(POE/Filter/Line.pm)
BuildRequires:  perl(POE/Filter/Stream.pm)
BuildRequires:  perl(POE/Filter/Transparent/SMTP.pm)
BuildRequires:  perl(POE/Wheel/ReadWrite.pm)
BuildRequires:  perl(POE/Wheel/SocketFactory.pm)
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Symbol.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
BuildRequires:  perl(IO/Socket/INET.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(POE/Component/Server/TCP.pm)
BuildRequires:  perl(POE/Wheel/ListenAccept.pm)
BuildRequires:  perl(Test/More.pm)
%if %{with perl_POE_Component_Client_SMTP_enables_optional_test}
# Optional tests:
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
%endif
Requires:       perl(POE.pm) >= 0.310
Requires:       perl(POE/Filter/Transparent/SMTP.pm) >= 0.200

# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(POE\|POE.Filter.Transparent.SMTP\).pm)/d

%description
POE::Component::Client::SMTP allows you to send email messages 
in an asynchronous manner, using POE.

%prep
%setup -q -n POE-Component-Client-SMTP-%{version}
%patch0  -p1
chmod -x LICENSE README Changes COPYING TODO eg/*

%build
perl Makefile.PL NO_PACKLIST=1 NO_PERLLOCAL=1 INSTALLDIRS=vendor
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc --no-dereference LICENSE COPYING
%doc README Changes TODO eg

%{perl_vendor_privlib}/*

%changelog
