# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/testlib.pm) perl(Gearman/JobStatus.pm) perl(Gearman/Objects.pm) perl(Gearman/ResponseParser.pm) perl(Gearman/Task.pm) perl(Gearman/Util.pm) perl(List/Util.pm) perl(POE.pm) perl(Scalar/Util.pm) perl(Test.pm) perl(Test/More.pm) perl(base.pm) perl(fields.pm) perl(String/CRC32.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name POE-Component-Gearman-Client
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Asynchronous client module for Gearman for POE applications
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AA/AAR/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use POE qw(Component::Gearman::Client);.
    # Instantiate a new client session.
    POE::Component::Gearman::Client->spawn(
        alias => 'my_gearman_client',
        job_servers => [ '127.0.0.1', '192.168.0.1:123' ],
    );

    # Overwrite job server list with a new one.
    POE::Kernel->post('my_gearman_client' => 'set_job_servers', ['10.0.0.1']);

    # Start a task
    $task = Gearman::Task->new(...); # with callbacks, etc
    POE::Kernel->post('my_gearman_client' => 'add_task', $task);

    # if you keep a reference to the client object you can also 
    # get a list of job servers during runtime:
    my $client = POE::Component::Gearman::Client->spawn(...);
    $arrayref = $client->job_servers;
    @array = $client->job_servers;


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changelog README
%perl_vendor_privlib/P*

%changelog
