# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(POE.pm) perl(POE/Component/IRC/Plugin.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name POE-Component-IRC-Plugin-Thanks
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: make witty responses to "thank you"s
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Z/ZO/ZOFFIX/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use strict;
    use warnings;

    use POE qw(Component::IRC  Component::IRC::Plugin::Thanks);

    my $irc = POE::Component::IRC->spawn(
            nick    => 'ThankBot',
            server  => 'irc.freenode.net',
            port    => 6667,
            ircname => 'Silly Thankie bot',
    ) or die "Oh noes :( $!";

    POE::Session->create(
        package_states => [
            main => [ qw( _start irc_001 ) ],
        ],
    );

    $poe_kernel->run();

    sub _start {
        $irc->yield( register => 'all' );

        # register our plugin
        $irc->plugin_add( 'Thanks' => POE::Component::IRC::Plugin::Thanks->new );

        $irc->yield( connect => { } );
        undef;
    }

    sub irc_001 {
        my ( $kernel, $sender ) = @_[ KERNEL, SENDER ];
        $kernel->post( $sender => join => '#zofbot' )
        undef;
    }


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README examples
%perl_vendor_privlib/P*

%changelog
