# BEGIN SourceDeps(oneline):
BuildRequires: perl(Filter/Template.pm) perl(Net/OSCAR.pm) perl(POE.pm) perl(Time/HiRes.pm) perl(XML/Parser.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name POE-Component-OSCAR
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: A POE Component for the Net::OSCAR module
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DM/DMCC/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The wrapper is very thin, so most of the useful documentation can be found in
the Net::OSCAR module.

Create a new connection with

    $oscar = POE::Component::OSCAR->new();

Though it has an object interface to make coding simpler, this actually spawns
a POE session.  The arguments to the object are passed directly to the 
Net::OSCAR module, with the exception of 'throttle'.  If passed in, the
'throttle' argument will indicate the minimum amount of time the module will
wait between sending messages.  This is useful, since bots that send lots of
messages quickly will get banned.

All other method calls on the object are passed directly to the Net::OSCAR
module.  For instance, to set the debug logging level, use

      $oscar->loglevel( 5 );

The only relevant POE::Component::OSCAR method is 'set_callback' which can
be used to post events to your own session via Net::OSCAR's callbacks.

For instance, to be notified of an incoming message, use

      $oscar->set_callback( im_in => 'im_in_state' );

where 'im_in' is a Net::OSCAR callback (see the Net::OSCAR documentation and
the oscartest script for all the callbacks) and 'im_in_state' is a state
in your POE session.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/P*

%changelog
