Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(POE/API/Peek.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-POE-Component-Server-HTTP
Version:        0.09
Release:        alt2_50
Summary:        Foundation of a POE HTTP Daemon
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/POE-Component-Server-HTTP
Source0:        https://cpan.metacpan.org/authors/id/R/RC/RCLAMP/POE-Component-Server-HTTP-%{version}.tar.gz
# Disable dependency on POE::API::Peek which is broken with perl-5.22,
# bug #1231252, CPAN RT#105463
Patch0:         POE-Component-Server-HTTP-0.09-Make-POE-API-Peek-optional.patch
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# POE::Component::Server::HTTP not useful
# Run-time:
BuildRequires:  perl(bytes.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
# Data::Dumper is undocumented optional feature
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(HTTP/Date.pm)
BuildRequires:  perl(HTTP/Request.pm)
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(HTTP/Status.pm)
# POE 0.3007 needed but future versions are 3-digit only
BuildRequires:  perl(POE.pm)
BuildRequires:  perl(POE/Component/Server/TCP.pm)
BuildRequires:  perl(POE/Driver/SysRW.pm)
BuildRequires:  perl(POE/Filter/HTTPD.pm)
BuildRequires:  perl(POE/Filter/Stream.pm)
BuildRequires:  perl(POE/Session.pm)
BuildRequires:  perl(POE/Wheel/ReadWrite.pm)
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Sys/Hostname.pm)
BuildRequires:  perl(vars.pm)
# Tests:
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(IO/Socket/INET.pm)
BuildRequires:  perl(LWP/ConnCache.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(POE/Kernel.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(YAML.pm)
# Keep Data::Dumper optional
# POE 0.3007 needed but future versions are 3-digit only
Requires:  perl(POE.pm) >= 0.300
Requires:  perl(POE/Component/Server/TCP.pm)
Requires:  perl(POE/Driver/SysRW.pm)
Requires:  perl(POE/Filter/HTTPD.pm)
Requires:  perl(POE/Filter/Stream.pm)
Requires:  perl(POE/Session.pm)
Requires:  perl(POE/Wheel/ReadWrite.pm)

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(POE.pm)/d

%description
POE::Component::Server::HTTP (PoCo::HTTPD) is a framework for building
custom HTTP servers based on POE. It is loosely modeled on the ideas of
apache and the mod_perl/Apache module.

%prep
%setup -q -n POE-Component-Server-HTTP-%{version}
%patch0  -p1

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} \;
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README test.perl
%{perl_vendor_privlib}/*

%changelog
