# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    POE-Component-Server-Syslog
%define upstream_version 1.22

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

License:    GPL+ or Artistic
Group:      Development/Perl
Summary:    Syslog server ability for POE
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/POE/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(IO/Socket.pm)
BuildRequires: perl(IO/Socket/INET.pm)
BuildRequires: perl(POE.pm)
BuildRequires: perl(POE/Driver/SysRW.pm)
BuildRequires: perl(POE/Wheel/ReadWrite.pm)
BuildRequires: perl(POE/Wheel/SocketFactory.pm)
BuildRequires: perl(Params/Validate.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Time/ParseDate.pm)
BuildArch:  noarch
Source44: import.info

%description
This module follows the POE::Filter specification. Actually, it
technically supports both the older specification (C<get>) and the newer
specification (C<get_one>). If, at some point, POE deprecates the older
specification, this module will drop support for it. As such, only use
of the newer specification is recommended.

%prep
%setup -q -n %{upstream_name}-%{upstream_version} 

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
rm -f t/000-signature.t
make test

%install
%makeinstall_std

%files
%doc Changes INSTALL LICENSE META.yml README examples
%{perl_vendor_privlib}/*


%changelog
