# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(POE.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(POE/Wheel/UDP.pm)
# END SourceDeps(oneline)
%define module_version 0.0302
%define module_name POE-Component-TFTPd
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0302
Release: alt1
Summary: A tftp-server, implemented through POE
Group: Development/Perl
License: perl
URL: http://search.cpan.org/dist/POE-Component-TFTPd

Source0: http://cpan.org.ua/authors/id/B/BE/BEVO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
POE::Session->create(.     inline_states => {
         _start        => sub {
             POE::Component::TFTPd->create;
             $_[KERNEL]->post($alias => 'start');
         },
         tftpd_init    => sub {
             my($client, $fh) = ($_[ARG0], undef);
             open($fh, "<", $client->filename) if($client->rrq);
             open($fh, ">", $client->filename) if($client->wrq);
             $client->{'fh'} = $fh;
         },
         tftpd_done    => sub {
             my $client = $_[ARG0];
             close $client->{'fh'};
         },
         tftpd_send    => sub {
             my $client = $_[ARG0];
             if ($client->{'fh'}) {
                 seek $client->{'fh'}, $client->last_block * $client->block_size, 0;
                 read $client->{'fh'}, my $data, $client->block_size;
                 $_[KERNEL]->post($alias => send_data => $client, $data);
             }
         },
         tftpd_receive => sub {
             my($client, $data) = @_[ARG0,ARG1];
             print { $client->{'fh'} } $data;
             $_[KERNEL]->post($alias => send_ack => $client);
         },
         tftpd_log     => sub {
             my($level, $client, $msg) = @_[ARG0..ARG2];
             warn(sprintf "%%s - %%s:%%i - %%s\n",
                 $level, $client->address, $client->port, $msg,
             );
         },
     },
 );


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
