# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    POE-Quickie
%define upstream_version 0.18

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    A lazy way to wrap blocking code and programs
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/POE/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Capture/Tiny.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(POE.pm)
BuildRequires: perl(POE/Filter/Stream.pm)
BuildRequires: perl(POE/Session.pm)
BuildRequires: perl(POE/Wheel/Run.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
If you need nonblocking access to an external program, or want to execute
some blocking code in a separate process, but you don't want to write a
wrapper module or some POE::Wheel::Run boilerplate code, then POE::Quickie
can help. You just specify what you're interested in (stdout, stderr,
and/or exit code), and POE::Quickie will handle the rest in a sensible way.

It has some convenience features, such as killing processes after a
timeout, and storing process-specific context information which will be
delivered with every event.

There is also an even lazier API which suspends the execution of your event
handler and gives control back to POE while your task is running, the same
way LWP::UserAgent::POE does. This is provided by the /FUNCTIONS functions
which are exported by default.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
