# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(POE.pm) perl(POE/Kernel.pm) perl(POE/Session.pm) perl(Test/More.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name POE-strict
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: strict mode for POE
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SU/SUNGO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
the POE::strict manpage acts a lot like the the strict manpage pragma in perl. It activates
internal constraints that are not normally active. The runtime behavior of
the POE manpage will be a lot more strict (duh) and potentially very loud if your code
is in any way questionable as far as the the POE manpage core is concerned. 

This module can be used as if it were the POE manpage itself. Suggested usage is the 
removal of all instances of `use POE' and replacing those with 
`use POE::strict'. 

For example,

  use POE::strict qw(Component::Client::TCP);

behaves exactly like

  use POE qw(Component::Client::TCP);

(Yeah, yeah, the former is not as semantically nice as the latter. Blame
`#poe'. They thought the functionality was a bonus and I agreed.)

The list of activated asserts is as follows:

=over

=item POE::Kernel::ASSERT_EVENTS

Assert when dispatching events to nonexistent sessions

=item POE::Kernel::ASSERT_USAGE

Assert if internal parameters are wacky

=item POE::Session::ASSERT_STATES

Yell about receiving unknown events

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README
%perl_vendor_privlib/P*

%changelog
