%define module_name PONAPI-Client
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Hijk.pm) perl(JSON/MaybeXS.pm) perl(Moose.pm) perl(Test/Moose.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(URI.pm) perl(YAHC.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002012
Release: alt1
Summary: Client to a {JSON:API} service (http://jsonapi.org/) v1.0
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MI/MICKEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`PONAPI::Client' is a {JSON:API} compliant client;
it should be able to communicate with any API-compliant service.

The client does a handful of checks required by the spec, then uses the Hijk manpage
to communicate with the service.

In most cases, all API methods return a response document:

    my $response = $client->retrieve(...);

In list context however, all api methods will return the request status and
the document:

    my ($status, $response) = $client->retrieve(...)

Response documents will look something like these:

    # Successful retrieve(type => 'articles', id => 2)
    {
        jsonapi  => { version => "1.0"         },
        links    => { self    => "/articles/2" },
        data     => { ... },
        meta     => { ... }, # May not be there
        included => [ ... ], # May not be there, see `include'
    }

    # Successful retrieve_all( type => 'articles' )
    {
        jsonapi => { version => "1.0"       },
        links   => { self    => "/articles" }, # May include pagination links
        data    => [
            { ... },
            { ... },
            ...
        ],
        meta     => { ... }, # May not be there
        included => [ ... ], # May not be there, see `include'
    }

    # Successful create(type => 'foo', data => { ... })
    {
        jsonapi => { version => "1.0"                 },
        links   => { self => "/foo/$created_id"       },
        data    => { type => 'foo', id => $created_id },
    }

    # Successful update(type => 'foo', id => 2, data => { ... })
    {
        jsonapi => { version => "1.0" },
        links   => { self => "/foo/2" }, # may not be there
        meta    => { ...              }, # may not be there
    }

    # Error, see http://jsonapi.org/format/#error-objects
    {
        jsonapi => { version => "1.0" },
        errors  => [
            { ... }, # error 1
            ...      # potentially others
        ],
    }

However, there are situations where the server may respond with a
`204 No Content' and no response document;...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/P*

%changelog
