Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(ExtUtils/CBuilder.pm) perl(JSON.pm) perl(Module/Build.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-POSIX-AtFork
Version:        0.04
Release:        alt5_21
Summary:        Hook registrations at fork(2)
# lib/POSIX/AtFork.pm:          GPL-1.0-or-later OR Artistic-1.0-Perl
# README:                       GPL-1.0-or-later OR Artistic-1.0-Perl
## Unbundled
# inc/Module/Install/XSUtil.pm: GPL-1.0-or-later OR Artistic-1.0-Perl
## Not used
# android/pthread-atfork.c:     BSD-2-Clause
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/POSIX-AtFork
Source0:        https://cpan.metacpan.org/authors/id/N/NI/NIKOLAS/POSIX-AtFork-%{version}.tar.gz
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Module/Install/XSUtil.pm)
# Run-time:
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XSLoader.pm)
# Tests:
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/SharedFork.pm)
Requires:       perl(XSLoader.pm) >= 0.100



# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(Test.More\|XSLoader\).pm)/d

%description
This module is an interface to pthread_atfork(3), which registers handlers
called before and after fork(2).

%package tests
Group: Development/Other
Summary:        Tests for %{name}
BuildArch:      noarch
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(Test/More.pm) >= 0.880

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n POSIX-AtFork-%{version}
# Remove bundled modules
rm -rf inc/*
perl -i -ne 'print $_ unless m{^inc/}' MANIFEST
# Remove unused sources
rm -rf android
perl -i -ne 'print $_ unless m{^android/}' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1 OPTIMIZE="$RPM_OPT_FLAGS"
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -size 0 -delete
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc Changes README
%dir %{perl_vendor_archlib}/auto/POSIX
%dir %{perl_vendor_archlib}/auto/POSIX/AtFork
%{perl_vendor_archlib}/auto/POSIX/AtFork/AtFork.so
%dir %{perl_vendor_archlib}/POSIX
%{perl_vendor_archlib}/POSIX/AtFork.pm

%files tests
%{_libexecdir}/%{name}

%changelog
