# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(constant.pm) perl(overload.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name Parse-JCONF
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Parse JCONF (JSON optimized for configs)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/O/OL/OLEG/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
JSON is good, but not very handy for configuration files. JCONF intended to fix this.

It has several differences with JSON format:

=over

=item bareword - the word which matches /^\w+$/

    some_word   # valid
    some word   # invalid
    "some_word" # invalid

=item bareword may be used only as object key or root key

=item object key may be bareword or string

    {test: 1}   # valid
    {"test": 1} # valid

=item JCONF root always consists of 0 or more trines: root key (bareword), equals sign (=), any valid JCONF value (number/string/true/false/null/object/array)

    value1 = [1,2] # root trine: root key (bareword), equals sign (=), any valid JCONF value

=item values in the object/array or root trines may be devided with comma "," (like in JSON) or with new line (or even several)

    val = [1,2,3,4] # with comma
    
    val = [         # with new line
        1
        2
        3
        4
    ]
    
    val = {         # several newlines are ok
        a: 1
        
        b: 2
    }
    
    val = {        # comma and newlines are ok
        a: 1,
        b: 2
    }
    
    val = {       # invalid, several commas is not ok
        a: 1,,b:2
    }

=item comma separator allowed after last element

    [1,2,3,4,] # ok
    {a:1,b:2,} # ok

=item new lines, carriage return, tabs are valid symbols in the string

    str = "This is valid multiline
    JCONF string"

=item # - is start of the comment, all from this symbol to the end of line will be interpreted as comment

    obj = {
        bool: false # this is comment
    }

=back
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
