%define module_name Parse-SAMGov
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(DateTime.pm) perl(DateTime/Format/Strptime.pm) perl(Email/Valid.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(IO/All.pm) perl(Test/More.pm) perl(Text/CSV_XS.pm) perl(URI.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.202
Release: alt1
Summary: Parses SAM Entity Management Public Extract Layout from SAM.gov
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VI/VIKAS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
my $parser = Parse::SAMGov::Parser->new;
    my $entities = $parser->parse_file(entity => 'SAM_PUBLIC_DAILY_20160701.dat');
    foreach my $e (@$entities) {
        ## do something with each entity
        say $e->DUNS, ' is a valid entity';
    }
    #... use in filter mode like grep ...
    my $entities_541511 = $parser->parse_file(entity =>
                                    'SAM_PUBLIC_DAILY_20160701.dat',
                                    sub {
                                        # filter all companies with NAICS code
                                        # being 541511
                                        return $_[0] if exists $_[0]->NAICS->{541511};
                                        return undef;
                                    });

    # ... do something ...
    my $exclusions = $parser->parse_file(exclusion => 'SAM_Exclusions_Public_Extract_16202.CSV');
    foreach my $e (@$exclusions) {
        ## do something with each entity that has been excluded
        say $e->DUNS, ' has been excluded';
    }
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE COPYRIGHT README.md README Changes examples
%perl_vendor_privlib/P*

%changelog
