%define module_name Parse-WWWAuthenticate
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Headers/Util.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Parse the WWW-Authenticate HTTP header
Group: Development/Perl
License: artistic_2
URL: http://github.com/reneeb/Parse-WWWAuthenticate

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RE/RENEEB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Parse::WWWAuthenticate qw(parse_wwwa);
  
  my $header = 'Basic realm="test"';
  my @challenges = parse_wwwa( $header );
  for my $challenge ( @challenges ) {
      print "Server accepts: " . $challenge->{name};
  }

kinda more real life:

  use LWP::UserAgent;
  use Parse::WWWAuthenticate qw(parse_wwwa);
  
  my $ua       = LWP::UserAgent->new;
  my $response = $ua->get('http://some.domain.example');
  my $header   = $response->header('WWW-Authenticate');
  
  my @challenges = parse_wwwa( $header );
  for my $challenge ( @challenges ) {
      print "Try to use $challenge->{name}...\n";
  }
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README CONTRIBUTING.md Changes CONTRIBUTORS
%perl_vendor_privlib/P*

%changelog
