Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(charnames.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-ParseUtil-Domain
Summary:        Utility for parsing a domain name into its components
Version:        2.427
Release:        alt2_24

# - ParseUtil::Domain is GPL+ or Artistic (the "Perl" license)
# - data/effective_tld_names.txt is MPL-2.0
# - ParseUtil::Domain::ConfigData is automatically generated during the build,
#   based on the contents of data/effective_tld_names.txt
License:        (GPL-1.0-or-later OR Artistic-1.0-Perl) AND MPL-2.0

URL:            https://metacpan.org/release/ParseUtil-Domain
Source0:        https://cpan.metacpan.org/authors/id/H/HE/HEYTRAV/ParseUtil-Domain-%{version}.tar.gz

BuildArch:      noarch

BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(autobox.pm)
BuildRequires:  perl(autobox/Core.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(List/MoreUtils.pm)
BuildRequires:  perl(Mock/Quick.pm)
BuildRequires:  perl(Modern/Perl.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(namespace/autoclean.pm)
BuildRequires:  perl(Net/IDN/Encode.pm)
BuildRequires:  perl(Net/IDN/Nameprep.pm)
BuildRequires:  perl(Net/IDN/Punycode.pm)
BuildRequires:  perl(parent.pm)
BuildRequires:  perl(Perl/Critic.pm)
BuildRequires:  perl(Regexp/Assemble/Compressed.pm)
#BuildRequires:  perl(Smart::Comments) - not used
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/Class.pm)
BuildRequires:  perl(Test/Deep.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Perl/Critic.pm)
BuildRequires:  perl(Test/Routine.pm)
BuildRequires:  perl(Test/Routine/Util.pm)
#BuildRequires:  perl(Unicode::CharName) >= 1.07 - not used
BuildRequires:  perl(utf8.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed


Source44: import.info

%description
A tool for parsing domain names. This module makes use of the data provided
by the Public Suffix List (http://publicsuffix.org/list/) to parse TLDs.


%prep
%setup -q -n ParseUtil-Domain-%{version}

# Remove incorrect executable bits
chmod -x lib/ParseUtil/Domain.pm \
         data/effective_tld_names.txt

# Add perl shebang to script
sed -i -e '1i#!%{__perl}' bin/suffix-regex.pl bin/punyconvert

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build


%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} %{buildroot}/*


%check
TEST_AUTHOR=1 make test


%files
%doc data/effective_tld_names.txt
%{_bindir}/punyconvert
%{_bindir}/suffix-regex.pl
%{_mandir}/man1/punyconvert.1*
%{perl_vendor_privlib}/ParseUtil*


%changelog
