%define module_name Passwd-Keyring-Auto
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Cmd.pm) perl(App/Cmd/Plugin/Prompt.pm) perl(Config/Simple.pm) perl(Config/Tiny.pm) perl(Exporter.pm) perl(File/HomeDir.pm) perl(File/ShareDir.pm) perl(Module/Build.pm) perl(Moo.pm) perl(MooseX/App.pm) perl(MooseX/App/Command.pm) perl(MooseX/Types/Perl.pm) perl(Passwd/Keyring/Memory.pm) perl(Passwd/Keyring/PWSafe3.pm) perl(Path/Tiny.pm) perl(Pod/Markdown.pm) perl(Pod/Readme.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(base.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0000
Release: alt1
Summary: interface to secure password storage(s)
Group: Development/Perl
License: perl
URL: https://helixteamhub.cloud/mekk/projects/perl/repositories/keyring-auto

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MEKK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Passwd::Keyring is about securely preserving passwords and similar
sensitive data applications use in backends like Gnome Keyring, KDE
Wallet, OSX/Keychain etc.

While modules like Passwd::Keyring::Gnome handle specific backends,
Passwd::Keyring::Auto tries to pick the best backend available,
considering the current desktop environment.

    use Passwd::Keyring::Auto;  # get_keyring

    my $keyring = get_keyring(app=>"My super scraper", group=>"Social passwords");

    my $username = "someuser";
    my $password = $keyring->get_password($username, "mylostspace.com");
    if(! $password) {
        # ... somehow interactively prompt for password
        $keyring->set_password($username, $password, "mylostspace.com");
    }
    login_somewhere_using($username, $password);
    if( password_was_wrong ) {
        $keyring->clear_password($username, "mylostspace.com");
    }

If any secure backend is available, password is preserved
for successive runs, and users need not be prompted.

The choice can be impacted by some environment variables,
see `get_keyring' documentation for details.

Finally, one can skip this module and be explicit:

    use Passwd::Keyring::Gnome;
    my $keyring = Passwd::Keyring::Gnome->new();

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
    # ... and so on


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README README.md example
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*

%files scripts
%_bindir/*
%changelog
