%define module_name Passwd-Keyring-KDEWallet
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(File/ShareDir.pm) perl(File/Which.pm) perl(Module/Build.pm) perl(Net/DBus.pm) perl(Pod/Markdown.pm) perl(Pod/Readme.pm) perl(Proc/SyncExec.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/Pod/Coverage.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0001
Release: alt1
Summary: Password storage implementation based on KDE Wallet.
Group: Development/Perl
License: perl
URL: https://helixteamhub.cloud/mekk/projects/perl/repositories/keyring-kdewallet

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MEKK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
KDE Wallet based implementation of the Passwd::Keyring manpage..
    use Passwd::Keyring::KDEWallet;

    my $keyring = Passwd::Keyring::KDEWallet->new(
         app=>"blahblah scraper",
         group=>"Johnny web scrapers",
    );

    my $username = "John";  # or get from .ini, or from .argv...

    my $password = $keyring->get_password($username, "blahblah.com");
    unless( $password ) {
        $password = <somehow interactively prompt for password>;

        # securely save password for future use
        $keyring->set_password($username, $password, "blahblah.com");
    }

    login_somewhere_using($username, $password);
    if( password_was_wrong ) {
        $keyring->clear_password($username, "blahblah.com");
    }

Note: see the Passwd::Keyring::Auto::KeyringAPI manpage for detailed comments
on keyring method semantics (this document is installed with
`Passwd::Keyring::Auto' package).


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md Changes example
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*
%changelog
