# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Perl/Role/String.pm) perl(File/Slurp.pm) perl(Glib/Object/Introspection.pm) perl(Module/Build.pm) perl(Pod/Markdown.pm) perl(Pod/Readme.pm) perl(Test/More.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm) typelib(Secret)
# END SourceDeps(oneline)
%define module_name Passwd-Keyring-Secret
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Password storage implementation using the GObject-based Secret library.
Group: Development/Perl
License: artistic_2
URL: https://search.cpan.org/~uhle/Passwd-Keyring-Secret/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UH/UHLE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Passwd::Keyring' compliant implementation that is using the
GObject-based Secret library to provide secure storage for passwords
and similar sensitive data.

    use Passwd::Keyring::Secret;

    my $keyring = Passwd::Keyring::Secret->new(
        app => "blahblah scraper",
        group => "Johnny web scrapers"
    );

    my $username = "John";  # or get from .ini, or from .argv ...

    my $password = $keyring->get_password($username, "blahblah.com");
    unless ($password)
    {
        $password = <somehow interactively prompt for password>;

        # securely save password for future use
        $keyring->set_password($username, $password, "blahblah.com");
    }

    login_somewhere_using($username, $password);
    if (password_was_wrong)
    {
        $keyring->clear_password($username, "blahblah.com");
    }

Note: see the Passwd::Keyring::Auto::KeyringAPI manpage for detailed comments
on keyring method semantics (this document is installed with the
the Passwd::Keyring::Auto manpage package).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE README Changes
%perl_vendor_privlib/P*

%changelog
