# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(parent.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Passwd-Unix
%define upstream_version 1.09

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    OO interface to files: passwd and shadow
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Passwd/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Config.pm)
BuildRequires: perl(Crypt/Password.pm)
BuildRequires: perl(Exporter/Tiny.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(IO/Compress/Bzip2.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Tie/Array/CSV.pm)
BuildArch:  noarch
Source44: import.info

%description
The Passwd::Unix module provides an abstract interface to /etc/passwd,
/etc/shadow and /etc/group format files. It is inspired by Unix::PasswdFile
module (that one does not handle /etc/shadow file, what is necessary in
modern systems like Sun Solaris 10 or Linux).

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
