%define module_name Perinci-CmdLine-Classic
# BEGIN SourceDeps(oneline):
BuildRequires: perl(BorderStyle/ASCII/SingleLineOuterOnly.pm) perl(ColorTheme/NoColor.pm) perl(ColorThemeBase/Static.pm) perl(ColorThemeRole/ANSI.pm) perl(Data/Format/Pretty/CompactJSON.pm) perl(Data/Format/Pretty/Console.pm) perl(Data/Unixish.pm) perl(Data/Unixish/lins.pm) perl(Data/Unixish/wrap.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(JSON/MaybeXS.pm) perl(Locale/TextDomain/UTF8.pm) perl(Log/ger.pm) perl(Module/Load/Util.pm) perl(Monkey/Patch/Action.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Perinci/Access.pm) perl(Perinci/Access/HTTP/Client.pm) perl(Perinci/Access/Perl.pm) perl(Perinci/Access/Schemeless.pm) perl(Perinci/Access/Simple/Client.pm) perl(Perinci/CmdLine/Base.pm) perl(Perinci/Object.pm) perl(Perinci/Result/Format.pm)
BuildRequires: perl(Perinci/Sub/Property/arg/cmdline.pm) perl(Perinci/Sub/To/CLIDocData.pm) perl(Perinci/Sub/Wrapper.pm) perl(Perinci/Tx/Manager.pm) perl(Pod/Coverage/TrustPod.pm) perl(Progress/Any.pm) perl(Progress/Any/Output.pm) perl(Progress/Any/Output/TermProgressBarColor.pm) perl(Role/Tiny.pm) perl(Scalar/Util.pm) perl(Syntax/Feature/EachOnArray.pm) perl(Term/App/Role/Attrs.pm) perl(Test/More.pm) perl(Test/Perinci/CmdLine.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Text/ANSITable.pm) perl(UUID/Random.pm) perl(experimental.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.816
Release: alt1
Summary: Rinci/Riap-based command-line application framework
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Perinci-CmdLine-Classic

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Perinci::CmdLine is a command-line application framework. It allows you to
create full-featured CLI applications easily and quickly.

See the Perinci::CmdLine::Manual manpage for more details.

There is also a blog post series on Perinci::CmdLine tutorial:
https://perlancar.wordpress.com/category/pericmd-tut/

Perinci::CmdLine::Classic is the heavier backend implementation which supports
some extra features currently not supported by the default backend
implementation the Perinci::CmdLine::Lite manpage. These features come at some startup
overhead cost and more dependencies. You normally should use
the Perinci::CmdLine::Any manpage instead to be able to switch backend on the fly.

Screenshots:

=for Pod::Coverage ^(.+)$

=begin HTML

<p><img src="http://blogs.perl.org/users/perlancar/screenshot-pericmd-help.jpg" /><br />Autogenerated help message

<p><img src="http://blogs.perl.org/users/perlancar/screenshot-pericmd-help_verbose.jpg" /><br />Autogenerated help message (verbose mode)

<p><img src="http://blogs.perl.org/users/perlancar/progany-tpc.jpg" /><br />Progress bar

<p><img src="http://blogs.perl.org/users/perlancar/screenshot-pericmd-completion.jpg" /><br />Tab completion

<p><img src="http://blogs.perl.org/users/perlancar/screenshot-pericmd-format.jpg" /><br />Some output formats

<p><img src="http://blogs.perl.org/users/perlancar/screenshot-trashu.jpg" /><br />Undo/redo

=end HTML

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*
%perl_vendor_privlib/C*

%changelog
