# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Perinci/CmdLine/Base.pm) perl(Perinci/CmdLine/Classic.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define module_name Perinci-CmdLine-Server
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Create Perinci::CmdLine::Classic object and some functions to access it in a Perl package
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Perinci-CmdLine-Server

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Currently, the Perinci::CmdLine::Classic manpage-based CLI applications have a
perceptible startup overhead (between 0.15-0.35s or even more, depending on your
hardware, those numbers are for 2011-2013 PC/laptop hardware). Some of the cause
of the overhead is subroutine wrapping (see the Perinci::Sub::Wrapper manpage) which also
involves compilation of the Sah manpage schemas (see the Data::Sah manpage), all of which are
necessary for the convenience of using the Rinci manpage metadata to specify aspects of
your functions.

This level of overhead is a bit annoying when we are doing shell tab completion
(Perinci::CmdLine::Classic-based applications call themselves for doing tab
completion, e.g. through bash's `complete -C progname progname' mechanism).
Ideally, tab completion should take no longer than 0.05-0.1s to feel
instantaneous.

One (temporary?) solution to this annoyance is to start a daemon that listens to
the Riap manpage requests (either through Unix domain sockets or TCP/IP). This way, the
completion external command can just be a lightweight HTTP client which asks the
server for the completion and displays the result to STDOUT for bash (this only
requires, e.g. the HTTP::Tiny::Unix manpage + the Complete::Bash manpage).

In the future, other functionalities aside from completion can also be
"off-loaded" to the server side to make the CLI program lighter and quicker to
start. This might require a refactoring of Perinci::CmdLine::Classic codebase so
it's more "stateless" and reusable/safer for multiple requests (perhaps will be
made non-OO in the core so it's clear what states are being passed?)

In the future, Perinci::CmdLine::Classic might also be configured to
automatically start a daemon after the first run (and retire/kill the daemon
after being idle for, say, 30 minute or an hour).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/P*

%changelog
