Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Perl-Critic-Bangs
Version:        1.14
Release:        alt1_3
Summary:        Collection of handy Perl::Critic policies
License:        Artistic-2.0
URL:            https://metacpan.org/release/Perl-Critic-Bangs
Source0:        https://cpan.metacpan.org/authors/id/P/PE/PETDANCE/Perl-Critic-Bangs-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(List/MoreUtils.pm)
BuildRequires:  perl(Perl/Critic.pm)
BuildRequires:  perl(Perl/Critic/Policy.pm)
BuildRequires:  perl(Perl/Critic/Utils.pm)
BuildRequires:  perl(Readonly.pm)
# Tests only:
BuildRequires:  perl(English.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Perl/Critic/Config.pm)
BuildRequires:  perl(Perl/Critic/PolicyFactory.pm)
BuildRequires:  perl(Perl/Critic/PolicyParameter.pm)
BuildRequires:  perl(Perl/Critic/TestUtils.pm)
BuildRequires:  perl(Perl/Critic/UserProfile.pm)
BuildRequires:  perl(PPI/Document.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Perl/Critic.pm) >= 1.122

# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(Test.More.pm)/d

%description
The rules included with the Perl::Critic::Bangs group include:
  - Commented-out code is usually noise.  It should be removed.
  - Watch for comments like "XXX", "TODO", etc.
  - Tests should have a plan.
  - Variables like $user and $user2 are insufficiently distinguished.
  - Determining the class in a constructor by using "ref($proto) || $proto".
  - Adding modifiers to a regular expression made up entirely of a variable
  created with qr() is usually not doing what you expect.
  - Vague variables like $data or $info are not descriptive enough.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(Test/More.pm) >= 0.960

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Perl-Critic-Bangs-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
# t/00_modules.t locates policies in MANIFEST
cp -a MANIFEST t %{buildroot}%{_libexecdir}/%{name}
# Remove tests that need modules in blib
rm %{buildroot}%{_libexecdir}/%{name}/t/93_version.t
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc Changes README.md TODO
%dir %{perl_vendor_privlib}/Perl
%dir %{perl_vendor_privlib}/Perl/Critic
%{perl_vendor_privlib}/Perl/Critic/Bangs.pm
%dir %{perl_vendor_privlib}/Perl/Critic/Policy
%{perl_vendor_privlib}/Perl/Critic/Policy/Bangs

%files tests
%{_libexecdir}/%{name}

%changelog
