Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Perl-Critic-Dynamic
Version:        0.05
Release:        alt2_39
Summary:        Non-static policies for Perl::Critic
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Perl-Critic-Dynamic
Source0:        https://cpan.metacpan.org/authors/id/T/TH/THALJEF/Perl-Critic-Dynamic-%{version}.tar.gz
# Adapt to changes in CGI-4.14, bug #1209554, CPAN RT#103382
Patch0:         Perl-Critic-Dynamic-0.05-test_AUTOLOAD_on_private_module.patch
BuildArch:      noarch
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Module/Build.pm)
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Devel/Symdump.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(Perl/Critic/Policy.pm)
BuildRequires:  perl(Perl/Critic/Utils.pm)
BuildRequires:  perl(Readonly.pm)
BuildRequires:  perl(Storable.pm)
# Tests only:
BuildRequires:  perl(CGI.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Perl/Critic/Policy.pm)
Requires:       perl(Devel/Symdump.pm) >= 2.070
Requires:       perl(Perl/Critic/Policy.pm) >= 1.108
Requires:       perl(Perl/Critic/Utils.pm) >= 1.108
Requires:       perl(Storable.pm) >= 2.160

# Remove underspecified dependencies



Source44: import.info
%filter_from_requires /^perl(Devel.Symdump.pm)/d
%filter_from_requires /^perl(Perl.Critic.\(Policy\|Utils\).pm)/d
%filter_from_requires /^perl(Storable.pm)/d

%description
Perl::Critic is primarily used as a static source code analyzer, which means
that it never compiles or executes any of the code that it examines. But
since Perl is a dynamic language, there are certain types of problems that
cannot be discovered until the code is actually compiled.

This distribution includes Perl::Critic::DynamicPolicy, which can be used as
a base class for Policies that wish to compile the code they analyze. 

%prep
%setup -q -n Perl-Critic-Dynamic-%{version}
%patch0  -p0

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
./Build test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
