Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(File/Which.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Perl-Critic-More
Version:        1.003
Release:        alt2_33
Summary:        Supplemental policies for Perl::Critic
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Perl-Critic-More
Source0:        https://cpan.metacpan.org/authors/id/T/TH/THALJEF/Perl-Critic-More-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
# Devel::NYTProf not used
BuildRequires:  perl(English.pm)
# File::Which not used
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(lib.pm)
# Run-time:
BuildRequires:  perl(List/MoreUtils.pm)
BuildRequires:  perl(Perl/Critic.pm)
BuildRequires:  perl(Perl/Critic/Policy.pm)
BuildRequires:  perl(Perl/Critic/Utils.pm)
BuildRequires:  perl(Perl/MinimumVersion.pm)
BuildRequires:  perl(Readonly.pm)
# Tests:
BuildRequires:  perl(Perl/Critic/Config.pm)
BuildRequires:  perl(Perl/Critic/TestUtils.pm)
BuildRequires:  perl(Perl/Critic/Violation.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(utf8.pm)
# Optional test:
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
Requires:       perl(Perl/Critic.pm) >= 1.098
Requires:       perl(Perl/MinimumVersion.pm) >= 0.140
Requires:       perl(Readonly.pm) >= 1.030


Source44: import.info
%filter_from_requires /^perl(Readonly.pm)/d

%description
This is a collection of Perl::Critic policies that are not included in the
Perl::Critic core for a variety of reasons.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(ExtUtils/Manifest.pm)

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Perl-Critic-More-%{version}
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
# Remove author tests
rm %{buildroot}%{_libexecdir}/%{name}/t/98*
rm %{buildroot}%{_libexecdir}/%{name}/t/99*
# MANIFEST file is used in test
cp -a MANIFEST %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes README TODO.pod
%{perl_vendor_privlib}/*

%files tests
%{_libexecdir}/%{name}

%changelog
