%define module_name Perl-Critic-Policy-Catalyst-ProhibitUnreachableCode
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Perl/Critic.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Readonly.pm) perl(Test2/V0.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Don't write code after an unconditional Catalyst detach.
Group: Development/Perl
License: gpl
URL: https://github.com/bluefeet/Perl-Critic-Policy-Catalyst-ProhibitUnreachableCode

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLUEFEET/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module was forked from
the Perl::Critic::Policy::ControlStructures::ProhibitUnreachableCode manpage
version `1.132' and modified to fit.

The primary difference is this module looks for these two
Catalyst specific bits of code as signifying a terminating statement:

    $c->detach();
    $c->redirect_and_detach();

The `redirect_and_detach' context method is available if you are using
the Catalyst::Plugin::RedirectAndDetach manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/P*

%changelog
