%define module_name Perl-Critic-Policy-CodeLayout-TabIndentSpaceAlign
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Module/Build.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Readonly.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm) perl(Test/Perl/Critic/Policy.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.0
Release: alt1
Summary: Use tabs for indenting, spaces for aligning.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Perl-Critic-Policy-CodeLayout-TabIndentSpaceAlign

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Hard tabs are a perfectly fine way to indent code for accessibility and
usability purposes, allowing different users to tweak indentation settings to
suit their needs and habits. However, hard tabs should not be used for
formatting / aligning, as this makes the display dependent on the tab-to-space
ratio of the user.

`Perl/Critic/Policy/CodeLayout/ProhibitHardTabs' has a setting that allows
leading tabs, but this not not fully represent the paradigm where tabs are
reserved for indenting and spaces for formatting/aligning. In particular, it
does not prevent indenting with spaces, while this module detects and prevents
it.

This Policy examines your source code, including POD, quotes, and HEREDOCs.
The contents of the `__DATA__' section are not examined.



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE ignore.txt README.md Changes examples
%perl_vendor_privlib/P*

%changelog
