%define module_name Perl-Critic-Policy-ControlStructures-ProhibitReturnInDoBlock
# BEGIN SourceDeps(oneline):
BuildRequires: perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Perl/Critic.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Test/More.pm) perl(Test2/V0.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Do not "return" in "do" block
Group: Development/Perl
License: perl
URL: https://github.com/utgwkk/Perl-Critic-Policy-ControlStructures-ProhibitReturnInDoBlock

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTGWKK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Using `return' statement in `do' block causes unexpected behavior. A `return' returns from entire subroutine, not from `do' block.

    sub foo {
        my ($x) = @_;
        my $y = do {
            return 2 if $x < 10; # not ok
            return 3 if $x < 100; # not ok
            4;
        };
        return $x * $y;
    }
    print foo(5); # prints 2, not 10;

If you want to do early-return, you should move the body of `do' block to a new subroutine and call it.

    sub calc_y {
        my ($x) = @_;
        return 2 if $x < 10;
        return 3 if $x < 100;
        return 4;
    }

    sub foo {
        my ($x) = @_;
        my $y = calc_y($x);
        return $x * $y;
    }
    print foo(5); # prints 10

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/P*

%changelog
